# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 1
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR1_strategy.txt
# LLM Suggested Fallback: C

def benevolent_trickster(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # First round
        return "C"
    
    if len(my_history) == 9:  # Last round
        if "always cooperate" in opponent_program_code.lower():
            return "D"
        if "always defect" in opponent_program_code.lower():
            return "D"
        return "D"
    
    if "always defect" in opponent_program_code.lower():
        return "D"
    if "always cooperate" in opponent_program_code.lower():
        if len(my_history) > 2:
            return "D"
        else:
            return "C"
    
    if opp_history[-1] == "C":
        return "C" if random.random() < 0.9 else "D"
    else:
        return "C" if random.random() < 0.1 else "D"